    --Loop through all of the items in the category
	
local pure_extraction_recipes = {}
local pure_extraction_technology = {}
local pure_extraction_subcategories = {}

local impure_extraction_recipes = {}
local impure_extraction_technology = {}
local impure_extraction_subcategories = {}

local ore_min = {6,7,8,9,10,11}
local ore_max = {10,11,12,13,14,15}
local ore_prob = {0.75,0.80,0.85,0.90,0.95,1.00}
local stone_min = {4,1,2,4,1,0}
local stone_max = {8,11,6,8,7,0}
local stone_prob = {1.00,0.8,0.875,0.35,0.175,0}

local timestier = {1,1.5,2.2,3.5,4,4.5}

local get_item_icons = function(item,tier)
    --Build the icons table
    local icons = {}
    if item.icons then
        for _ , icon in pairs(item.icons) do
            icons[#icons+1] = icon
        end
    else
        icons[#icons+1] = {icon = item.icon}
    end
    icons[#icons+1] = {icon = "__omnimatter__/graphics/icons/extraction-"..tier..".png"}
    return icons
end
local get_tech_icons = function(item)
    --Build the icons table
    local icon = ""
    if not item.mod then
		icon = "__omnimatter__"
	else
		icon = "__"..item.mod.."__"
	end
	icon=icon.."/graphics/extraction/"..item.ore.name..".png"
    return icon
end

local reqpure = function(tier,level,item)
	local req = {}
	if (level-1)%2==0 then
		if ((level+1)/2+tier-1) <= omnimatter.omnitractortiers+2 then
			if data.raw.technology["omni-sorting-electric-"..((level+1)/2+tier-1)] then
				req[#req+1]="omni-sorting-electric-"..((level+1)/2+tier-1)
			else
				req[#req+1]="omni-sorting-"..item.name.."-"..(level-1)
			end
		else
			req[#req+1]="omni-sorting-"..item.name.."-"..(level-1)
		end
	else
		req[#req+1]="omni-sorting-"..item.name.."-"..(level-1)
	end
	return req
end

local techcost = function(tier)
	local c = {}
	for lvl=1,math.floor((tier-1)/2+1) do
		c[#c+1] = {"science-pack-"..lvl,math.pow(2,math.floor((tier-1)/2+1)-lvl)}
	end
	return c
end

local get_tech_times = function(tier)
	local t = 25*timestier[tier]
	return t
end

--Pure extraction
local ore_count = 0
local tier_count = {}
local omnitiers = {}
for i=1,#omnisource do
	--Check for hidden flag to skip later

	local item = omnisource[i].ore
	local tier = omnisource[i].tier
	if not tier_count[tier] then tier_count[tier] = 0 end
	tier_count[tier]=tier_count[tier]+1
	
	if not omnitiers[tier] then omnitiers[tier]={} end
	omnitiers[tier][#omnitiers[tier]+1]=item
	
	ore_count=ore_count+1
	
	local sub_group = "items"
    local order = "compressed-"..item.type.."-"..item.name
    --local techname = get_tech("items")
    local icons = get_item_icons(item,tier)
	
	--Automated subcategories
	local sorting = {
    type = "item-subgroup",
    name = "omni-"..item.name,
	group = "omnimatter",
	order = "aa",
	}
	
	pure_extraction_subcategories[#pure_extraction_subcategories+1] = sorting
	
	for t=1,6 do
		
		local icons = get_item_icons(item,t)
		local r = {}
        local loc_key = {"item-name."..item.name}
		
		if t<6 then
		res = {
		{type = "item", name = item.name, amount_min = ore_min[t], amount_max = ore_max[t], probability = ore_prob[t]},
		{type = "item", name = "stone-crushed", amount_min = stone_min[t], amount_max = stone_max[t], probability = stone_prob[t]},
		}
		end
		

		--Pure extraction recipes
		local loc_key = {"item-name."..item.name,t}
		local extraction = {
		type = "recipe",
		name = item.name.."-extraction-"..t,
        localised_name = {"recipe-name.pure_extraction", loc_key},
        localised_description = {"recipe-description.pure_extraction", loc_key},
		category = "omnite-extraction",
		subgroup = "omni-"..item.name,
        enabled = false,
        ingredients = {
        {"omnite", 12}
        },
        --subgroup = "compressor-"..sub_group,
		order = "a[angelsore1-crushed]",
		icons = icons,
        --inter_item_count = item_count,
		results = {
		{type = "item", name = item.name, amount_min = ore_min[t], amount_max = ore_max[t], probability = ore_prob[t]},
		{type = "item", name = "stone-crushed", amount_min = stone_min[t], amount_max = stone_max[t], probability = stone_prob[t]},
		},
        energy_required = 5*(math.floor((t+(tier-1)/2)/2+0.5)), --Must fix so this matches tiers and grows
        }
		pure_extraction_recipes[#pure_extraction_recipes+1] = extraction
		
		loc_key = {"item-name."..item.name}
		--Pure Technologies
		local techicons = get_tech_icons(omnisource[i])
		local req = reqpure(tier,t,item)
		local cost = techcost(math.floor(t/2+0.5)+tier)
		local count = get_tech_times(t)
		
		local tech = 	{ -- Sp 1
		name = "omni-sorting-"..item.name.."-"..t,
        localised_name = {"technology-name.pure_extraction", loc_key},
		type = "technology",
		icon = techicons,
		icon_size = 128,
		prerequisites = req,
		effects =
		{
		  {
			type = "unlock-recipe",
			recipe = item.name.."-extraction-"..t
		  },
		},
		unit  =
		{
		  count = 25*math.pow(2,tier)*timestier[t],
		  ingredients = cost,
		  time = 15
		},
		order = "c-a"
		}
		pure_extraction_technology[#pure_extraction_technology+1] = tech
	end
end
data:extend(pure_extraction_subcategories)
data:extend(pure_extraction_technology)
data:extend(pure_extraction_recipes)

local impure_icons =function(t,kind)
    local icons = {}
	--for i=1,#omnisource do
	--	if omnisource[i].tier == t then
	--	    if omnisource[i].ore.icons then
	--			for _ , icon in pairs(omnisource[i].ore.icons) do
	--				icons[#icons+1] = icon
	--			end
	--		else
	--			icons[#icons+1] = {icon = omnisource[i].ore.icon}
	--		end
	--		icons[#icons+1]={icon = omnisource[i].ore.icon}
	--	end
	--end
	if kind then
		
		icons[#icons+1] = {icon = kind.icon}
		icons[#icons+1] = {icon = "__omnimatter__/graphics/icons/specialized-impure-extraction.png"}
		icons[#icons+1] = {icon = "__omnimatter__/graphics/icons/extraction-"..t..".png"}
	else
		icons[#icons+1] = {icon = "__omnimatter__/graphics/icons/omnite.png"}
		icons[#icons+1] = {icon = "__omnimatter__/graphics/icons/extraction-"..t..".png"}
	end
    return icons
end

local proper_result = function(tier, level,focus)
	local res = {}
	if level == 0 then
		for i=1,#omnisource do
			if omnisource[i].tier == tier then
				res[#res+1]={type = "item", name = omnisource[i].ore.name, amount=1}
				--icons[#icons+1]={icon = omnisource[i].ore.icon,scale=0.5,shift = {1.00, -0.05}}
			end
		end
		res[#res+1]={type = "item", name = "stone-crushed", amount=10-#res}
	else
		for i=1,#omnisource do
			if omnisource[i].tier == tier then
				if omnisource[i].ore.name == focus then
					res[#res+1]={type = "item", name = omnisource[i].ore.name, amount=1+level}
				else
					res[#res+1]={type = "item", name = omnisource[i].ore.name, amount=1}
				
				end
				--icons[#icons+1]={icon = omnisource[i].ore.icon,scale=0.5,shift = {1.00, -0.05}}
			end
		end
		res[#res+1]={type = "item", name = "stone-crushed", amount=10-#res-level}
	end

	return res
end

local get_impure_tech_icon = function(item)
	local ic = {}
    if not item.mod then
		ic = "__omnimatter__"
	else
		ic = "__"..item.mod.."__"
	end
	ic=ic.."/graphics/extraction/impure_"..item.name..".png"
    return ic
end

local get_impure_req = function(lvl,tier,item)
    --Build the icons table
    local req = {}
	if lvl == 1 and tier == 1 then
		req[#req+1]="omni-extraction-impure-base"
	elseif lvl==1 then
		req[#req+1]="omni-sorting-electric-"..(tier-1)
	else
		req[#req+1]="omni-impure-"..item.name.."-extraction-"..(lvl-1)
	end
	
    return req
end

--Impure recipies
for t=1,#omnitiers do
	--Base mix
	local icons = impure_icons(t)
	local res = proper_result(t,0)

	
	--local icons = impure_icons(t)
	
	local loc_key = {t}
	local cat = "omnite-extraction"
	if t==1 then cat = "omnite-extraction-burner" end
	local extraction = {
	type = "recipe",
	name = "base-impure-extraction-"..t,
    localised_name = {"recipe-name.base_impure", loc_key},
    localised_description = {"recipe-description.base_impure", loc_key},
	category = cat,
	subgroup = "omni-impure-basic",
    enabled = false,
    ingredients = {
    {"omnite", 10}
    },
       --subgroup = "compressor-"..sub_group,
	order = "a[angelsore1-crushed]",
	icons = icons,
       --inter_item_count = item_count,
	results = res,
    energy_required = 5*(math.floor(t/2+0.5)), 
    }
	impure_extraction_recipes[#impure_extraction_recipes+1] = extraction
	if t==1 then
	
		local tech = 	{ -- Sp 1
		name = "omni-extraction-impure-base",
		--localised_name = {"recipe-name.base_impure", loc_key},
		type = "technology",
		icon = "__omnimatter__/graphics/technology/omnimatter.png",
		icon_size = 128,
		prerequisites = {},
		effects =
		{
		  {
			type = "unlock-recipe",
			recipe = "base-impure-extraction-"..t
		  },
		},
		unit =
		{
		  count = 30,
		  ingredients = {
		  {"science-pack-1", 1},
		  },
		  time = 15
		},
		order = "c-a"
		}
		impure_extraction_technology[#impure_extraction_technology+1] = tech
	
	end
	local sorting = {
		type = "item-subgroup",
		name = "omni-impure-"..t,
		group = "omnimatter",
		order = "aa",
	}
			
	impure_extraction_subcategories[#impure_extraction_subcategories+1] = sorting
	for i=1, #omnisource do
		if omnisource[i].tier == t then
			for l=1,3 do
				res = proper_result(t,l,omnisource[i].ore.name)
				icons = impure_icons(l,omnisource[i].ore)
				
				local cat={}
				
				if t==1 then cat = "omnite-extraction-burner" else cat = "omnite-extraction" end
				loc_key = {"item-name."..omnisource[i].ore.name,l}
				--impure focused recipe
				local extraction = {
				type = "recipe",
				name = "impure-"..omnisource[i].ore.name.."-extraction-"..l,
				localised_name = {"recipe-name.impure_focused", {"item-name."..omnisource[i].ore.name,l}},
				localised_description = {"recipe-description.focused_impure", loc_key},
				category = cat,
				subgroup = "omni-impure-"..t,
				enabled = false,
				ingredients = {
				{"omnite", 10}
				},
				   --subgroup = "compressor-"..sub_group,
				order = "a[angelsore1-crushed]",
				icons = icons,
				   --inter_item_count = item_count,
				results = res,
				energy_required = 5*(math.floor(t/2+0.5)), 
				}
				impure_extraction_recipes[#impure_extraction_recipes+1] = extraction
				
				local req = get_impure_req(l,t,omnisource[i].ore)
				icons = get_impure_tech_icon(omnisource[i].ore)
				local tech = 	{
				name = "omni-impure-"..omnisource[i].ore.name.."-extraction-"..l,
				localised_name = {"technology-name.impure_focused", {"item-name."..omnisource[i].ore.name,l}},
				type = "technology",
				--icons = icons,
				icon = icons,
				icon_size = 128,
				prerequisites = req,
				effects =
				{
				  {
					type = "unlock-recipe",
					recipe = "impure-"..omnisource[i].ore.name.."-extraction-"..l
				  },
				},
				unit =
				{
				  count = 25*t*l,
				  ingredients = {
				  {"science-pack-1", 1},
				  },
				  time = 10
				},
				order = "c-a"
				}
				impure_extraction_technology[#impure_extraction_technology+1] = tech
			end
			--tech_add_prerequisite("omni-sorting-electric-"..t,"omni-impure-"..omnisource[i].ore.name.."-extraction-3")
		end
	end
	
	--impure_extraction_recipes[#impure_extraction_recipes+1] = extraction
end
data:extend(impure_extraction_technology)
data:extend(impure_extraction_recipes)
data:extend(impure_extraction_subcategories)
	

	--  {type = "item", name = "angels-ore1", amount_min = 6, amount_max = 10, probability = 0.75},
	--  {type = "item", name = "stone-crushed", amount_min = 4, amount_max = 8, probability = 1.00},
	
	